/*
 * Decompiled with CFR 0.152.
 */
package jclass.datasource.bean;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jclass.beans.JCTabEditor;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCOutliner;
import jclass.bwt.JCOutlinerEvent;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerListener;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCOutlinerNodeStyle;
import jclass.datasource.DataModel;
import jclass.datasource.DataSourceBeanInstance;
import jclass.datasource.LocaleBundle;
import jclass.datasource.MetaDataModel;
import jclass.datasource.treemodel.TreeModel;
import jclass.datasource.treemodel.TreeNode;
import jclass.util.JCVector;

public class DataBindingEditor
extends JCTabEditor
implements JCOutlinerListener {
    protected JCOutliner outliner;
    protected boolean topLevelOnly = false;

    public DataBindingEditor() {
        this(false);
    }

    public DataBindingEditor(boolean bl) {
        this.topLevelOnly = bl;
        this.outliner = new JCOutliner(this.getTree());
        this.outliner.setAllowMultipleSelections(false);
        this.outliner.getOutliner().setBackground(Color.white);
        this.outliner.setPreferredSize(400, 300);
        this.outliner.getDefaultNodeStyle().setShortcut(true);
        this.outliner.addItemListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.outliner, "Center");
        this.resize(200, 300);
    }

    protected boolean hasChildren(MetaDataModel metaDataModel) {
        return metaDataModel.hasChildren();
    }

    protected void addChildren(JCOutlinerFolderNode jCOutlinerFolderNode, MetaDataModel metaDataModel) {
        Enumeration enumeration = ((TreeNode)((Object)metaDataModel)).getChildren().elements();
        while (enumeration.hasMoreElements()) {
            this.addMetaDataLevel(jCOutlinerFolderNode, (MetaDataModel)enumeration.nextElement(), null);
        }
    }

    private JCOutlinerFolderNode getTree() {
        Vector vector = DataSourceBeanInstance.getInstances();
        JCOutlinerFolderNode jCOutlinerFolderNode = new JCOutlinerFolderNode(null, LocaleBundle.string("Data Source"));
        jCOutlinerFolderNode.setStyle(new JCOutlinerNodeStyle());
        int n = 0;
        while (n < vector.size()) {
            TreeModel treeModel;
            DataModel dataModel = (DataModel)vector.elementAt(n);
            if (dataModel != null && (treeModel = dataModel.getMetaDataTree()) != null) {
                MetaDataModel metaDataModel = (MetaDataModel)treeModel.getRoot();
                this.addMetaDataLevel(jCOutlinerFolderNode, metaDataModel, dataModel.getModelName());
            }
            ++n;
        }
        return jCOutlinerFolderNode;
    }

    private void addMetaDataLevel(JCOutlinerFolderNode jCOutlinerFolderNode, MetaDataModel metaDataModel, String string) {
        if (metaDataModel == null) {
            return;
        }
        try {
            JCOutlinerNodeStyle jCOutlinerNodeStyle = new JCOutlinerNodeStyle();
            String string2 = metaDataModel.getDescription();
            if (string2 == null || string2.length() == 0) {
                string2 = "No Description";
            }
            if (string != null) {
                string2 = String.valueOf(string) + ":" + string2;
            }
            JCOutlinerNode jCOutlinerNode = null;
            if (this.hasChildren(metaDataModel) && !this.topLevelOnly) {
                jCOutlinerNodeStyle.setShortcut(true);
                jCOutlinerNode = new JCOutlinerFolderNode(null, 1, string2);
            } else {
                jCOutlinerNode = new JCOutlinerNode(string2);
            }
            jCOutlinerNode.setStyle(jCOutlinerNodeStyle);
            jCOutlinerFolderNode.addNode(jCOutlinerNode);
            if (jCOutlinerNode instanceof JCOutlinerFolderNode) {
                this.addChildren((JCOutlinerFolderNode)jCOutlinerNode, metaDataModel);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
    }

    public void outlinerNodeSelectBegin(JCOutlinerEvent jCOutlinerEvent) {
        JCOutlinerNode jCOutlinerNode = jCOutlinerEvent.getNode();
        if (jCOutlinerNode == this.outliner.getRootNode()) {
            jCOutlinerEvent.setAllowChange(false);
        }
    }

    public void outlinerNodeSelectEnd(JCOutlinerEvent jCOutlinerEvent) {
        this.support.firePropertyChange("dataBinding", null, this.getValue());
    }

    public void outlinerFolderStateChangeBegin(JCOutlinerEvent jCOutlinerEvent) {
    }

    public void outlinerFolderStateChangeEnd(JCOutlinerEvent jCOutlinerEvent) {
    }

    public Object getValue() {
        return this.getDataBindingHierarchy();
    }

    public void setValue(Object object) {
        this.refreshTree();
        this.setDataBindingHierarchy((String)object);
    }

    private void refreshTree() {
        JCOutlinerFolderNode jCOutlinerFolderNode = (JCOutlinerFolderNode)this.outliner.getRootNode();
        jCOutlinerFolderNode.setChildren(null);
        jCOutlinerFolderNode = this.getTree();
        this.outliner.setRootNode(jCOutlinerFolderNode);
        this.outliner.folderChanged(jCOutlinerFolderNode);
    }

    public String getAsText() {
        String string = this.getDataBindingHierarchy();
        if (string == null || string.equals("")) {
            string = new String(LocaleBundle.string("Select a Data Source..."));
        }
        return string;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = this.getAsText();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n);
    }

    public String getJavaInitializationString() {
        return "\"" + this.getDataBindingHierarchy() + "\"";
    }

    protected String getDataBindingHierarchy() {
        JCOutlinerNode jCOutlinerNode = this.outliner.getSelectedNode();
        if (jCOutlinerNode == null) {
            return null;
        }
        String string = "";
        while (jCOutlinerNode.getParent() != null) {
            string = string.length() == 0 ? jCOutlinerNode.getLabelString() : String.valueOf(jCOutlinerNode.getLabelString()) + "|" + string;
            jCOutlinerNode = jCOutlinerNode.getParent();
        }
        return string;
    }

    protected void setDataBindingHierarchy(String string) {
        JCOutlinerNode jCOutlinerNode = this.outliner.getRootNode();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            block0: while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                JCVector jCVector = jCOutlinerNode.getChildren();
                if (jCVector == null) continue;
                int n = 0;
                while (n < jCVector.size()) {
                    JCOutlinerNode jCOutlinerNode2 = (JCOutlinerNode)jCVector.elementAt(n);
                    if (jCOutlinerNode2 instanceof JCOutlinerFolderNode) {
                        ((JCOutlinerFolderNode)jCOutlinerNode2).setState(5);
                    }
                    if (this.outliner.isShowing()) {
                        this.outliner.makeNodeVisible(jCOutlinerNode2);
                    }
                    if (string2.equals(jCOutlinerNode2.getLabelString())) {
                        jCOutlinerNode = jCOutlinerNode2;
                        continue block0;
                    }
                    ++n;
                }
            }
        }
        if (jCOutlinerNode != null && jCOutlinerNode instanceof JCOutlinerFolderNode && jCOutlinerNode != this.outliner.getRootNode()) {
            ((JCOutlinerFolderNode)jCOutlinerNode).setState(1);
        }
        if (jCOutlinerNode == this.outliner.getRootNode()) {
            this.outliner.selectNode(null, null);
            return;
        }
        this.outliner.selectNode(jCOutlinerNode, null);
        if (this.outliner.isShowing()) {
            this.outliner.makeNodeVisible(jCOutlinerNode);
        }
    }
}

